package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.stage.transfer.StageMessageControl;
import gov.va.med.mhv.integration.phr.transfer.DataLoadResponse;
import gov.va.med.mhv.integration.phr.transfer.FacilityInfo;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;
import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Set;

/**
 * User: Rob Murtha
 */
public interface TrackingService {

    public void trackMessage(StageMessageControl message);

    public void trackBeforeQueryService(QueryRequest request);
    public void trackAfterQueryService(QueryRequest request, QueryServiceResponse response);

    public void trackBeforeDataService(DataLoadResponse response);
    public void trackAfterDataService(StageMessageControl message, DataServiceResponse serviceResponse);
    public void trackAfterDataService(DataLoadResponse response, DataServiceResponse serviceResponse);

    public Set<String> getEnabledExtracts();
    public Set<String> getStationNumbers(PatientIdentifier patient);

    public PatientExtractStatus getStatus(PatientIdentifier patient);
    public FacilityInfo findFacilityByStationNumber(String stationNumber);
    
    public boolean isFieldTester(String icn, String accessRoleName);
    
}
